document.addEventListener("DOMContentLoaded", function (_event) {
  const toggleBtn = document.querySelector(".show-toggle");
  const showIcon = document.querySelector(".show-icon");
  const hideIcon = document.querySelector(".hide-icon");
  const accessKeyInput = document.querySelector(".access-key_input");
  const accessKeyForm = document.querySelector("#accessKeyForm");
  const successContainer = document.querySelector(".success");
  const messagesContainer = document.querySelector(".alert");

  toggleBtn.addEventListener("click", () => {
    if (!Array.from(showIcon.classList).includes("hidden")) {
      hideIcon.classList.remove("hidden");
      showIcon.classList.add("hidden");
      accessKeyInput.setAttribute("type", "text");
    } else {
      hideIcon.classList.add("hidden");
      showIcon.classList.remove("hidden");
      accessKeyInput.setAttribute("type", "password");
    }
  });

  accessKeyInput.addEventListener("keyup", (e) => {
    if(e.key === 'Enter') return;
    messagesContainer.innerHTML = "";
    if (Array.from(accessKeyInput.classList).includes("input_error")) {
      accessKeyInput.classList.remove("input_error");
    }
  });

  accessKeyForm.addEventListener("submit", async function (evt) {
    evt.preventDefault();

    const data = new FormData(this);

    if (!data.get("accessKey")) {
      return false;
    }

    const res = await fetch("/api/login", {
      method: "POST",
      body: data,
    });
    const { success, errors, isLogged } = await res.json();

    if (success && isLogged) {
      const searchParams = new URLSearchParams(window.location.search);
      const redirect = searchParams.get("redirect");

      if (redirect === "studio") {
        location.href = "/studio/";
        return;
      }

      if (redirect === "DataExplorer") {
        location.href = "/dataexplorer/";
        return;
      }

      if (redirect === "webadmin") {
        location.href = "/index.html";
        return;
      }

      accessKeyForm.classList.add("hidden");
      successContainer.classList.remove("hidden");
      return true;
    }

    if (errors) {
      let msg;
      if (errors.length > 1) {
        msg += `${errors.reduce(
          (one) => `<p class="error_message">${one}</p>`,
          ""
        )}`;
      } else {
        msg = `<p class="error_message"><svg viewBox="0 0 20 20" fill="currentColor">
        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
      </svg>${errors[0]}</p>`;
      }

      messagesContainer.innerHTML = msg;
      accessKeyInput.classList.add("input_error");
    }
  });
});
